// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;

use super::internal::InternalHeredoc;
use crate::blobs::{HasBlob, Blob};

/// Represents a here-document literal (both with and without interpolation)
///
/// It's similar to `Dstr` in terms of abstract syntax tree, but has different source maps.
#[repr(C)]
pub struct Heredoc {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Heredoc {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Heredoc")
            .field("parts", &self.get_parts())
            .field("heredoc_body_l", &self.get_heredoc_body_l())
            .field("heredoc_end_l", &self.get_heredoc_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Heredoc {
    fn eq(&self, other: &Self) -> bool {
        if self.get_parts() != other.get_parts() {
            return false
        }
        if self.get_heredoc_body_l() != other.get_heredoc_body_l() {
            return false
        }
        if self.get_heredoc_end_l() != other.get_heredoc_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Heredoc {
    // getters
    /// Returns `parts` field
    pub fn get_parts(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__heredoc__get_parts(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `heredoc_body_l` field
    pub fn get_heredoc_body_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__heredoc__get_heredoc_body_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `heredoc_end_l` field
    pub fn get_heredoc_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__heredoc__get_heredoc_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__heredoc__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `parts` field
    pub fn set_parts(&mut self, parts: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__heredoc__set_parts(&mut self.blob, parts.into_blob()) }
    }
    /// Sets `heredoc_body_l` field
    pub fn set_heredoc_body_l(&mut self, heredoc_body_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__heredoc__set_heredoc_body_l(&mut self.blob, heredoc_body_l.into_blob()) }
    }
    /// Sets `heredoc_end_l` field
    pub fn set_heredoc_end_l(&mut self, heredoc_end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__heredoc__set_heredoc_end_l(&mut self.blob, heredoc_end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__heredoc__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalHeredoc {
        unsafe { lib_ruby_parser__external__nodes__heredoc__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__heredoc__get_parts(blob: *const Blob<Heredoc>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__heredoc__set_parts(blob: *mut Blob<Heredoc>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__heredoc__get_heredoc_body_l(blob: *const Blob<Heredoc>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__heredoc__set_heredoc_body_l(blob: *mut Blob<Heredoc>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__heredoc__get_heredoc_end_l(blob: *const Blob<Heredoc>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__heredoc__set_heredoc_end_l(blob: *mut Blob<Heredoc>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__heredoc__get_expression_l(blob: *const Blob<Heredoc>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__heredoc__set_expression_l(blob: *mut Blob<Heredoc>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__heredoc__into_internal(blob: Blob<Heredoc>) -> InternalHeredoc;
    fn lib_ruby_parser__external__nodes__heredoc__drop(blob: *mut Blob<Heredoc>);
}

impl InnerNode for Heredoc {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_parts());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "dstr"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_parts().iter() { node.inner_ref().print_with_locs(); }
        self.get_heredoc_body_l().print("heredoc_body");
        self.get_heredoc_end_l().print("heredoc_end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Heredoc {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__heredoc__drop(&mut self.blob) }
    }
}
