// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a hash literal (i.e. `{ foo: 42 }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Hash {
    /// A list of key-value pairs
    pub pairs: Vec<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// { a: 1 }
    /// ~
    /// ```
    ///
    /// `None` if hash literal is implicit, e.g. `foo(key: "value")`
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// { a: 1 }
    ///        ~
    /// ```
    ///
    /// `None` if hash literal is implicit, e.g. `foo(key: "value")`
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// { a: 1 }
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Hash {
    // getters

    /// Returns `pairs` field
    pub fn get_pairs(&self) -> &Vec<Node> {
        &self.pairs
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `pairs` field
    pub fn set_pairs(&mut self, pairs: Vec<Node>) {
        self.pairs = pairs;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalHash {
        let Self { pairs, begin_l, end_l, expression_l,  } = self;
        super::InternalHash { pairs, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for Hash {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_pairs());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "hash"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_pairs().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}
