// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `for` loop
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct For {
    /// Variable that is used in loop, `Lvasgn("a")` in `for a in b; end`
    pub iterator: Box<Node>,

    /// Collection that is for iteration. `Lvar("b")` in `for a in b; end`
    pub iteratee: Box<Node>,

    /// Body of the loop. `None` if there's no body
    pub body: Option<Box<Node>>,

    /// Location of the `for` keyword
    ///
    /// ```text
    /// for a in b; end
    /// ~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `in` keyword
    ///
    /// ```text
    /// for a in b; end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the `do` keyword
    ///
    /// ```text
    /// for a in b do; end
    ///            ~~
    /// ```
    ///
    /// **Note**: this `do` is optional, and so `begin_l` can be `None`.
    pub begin_l: Loc,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// for a in b; end
    ///             ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// for a in b; end
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl For {
    // getters

    /// Returns `iterator` field
    pub fn get_iterator(&self) -> &Box<Node> {
        &self.iterator
    }

    /// Returns `iteratee` field
    pub fn get_iteratee(&self) -> &Box<Node> {
        &self.iteratee
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `iterator` field
    pub fn set_iterator(&mut self, iterator: Box<Node>) {
        self.iterator = iterator;
    }

    /// Sets `iteratee` field
    pub fn set_iteratee(&mut self, iteratee: Box<Node>) {
        self.iteratee = iteratee;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalFor {
        let Self { iterator, iteratee, body, keyword_l, operator_l, begin_l, end_l, expression_l,  } = self;
        super::InternalFor { iterator, iteratee, body, keyword_l, operator_l, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for For {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_iterator());
        result.push_node(self.get_iteratee());
        result.push_maybe_node_or_nil(self.get_body());





        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "for"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_iterator().inner_ref().print_with_locs();
        self.get_iteratee().inner_ref().print_with_locs();
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_operator_l().print("operator");
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
