// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents range literal with excluded `end` (i.e. `1...3`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Erange {
    /// Begin of the range, `None` if range has no begin (i.e `...42`)
    pub left: Option<Box<Node>>,

    /// End of the range, `None` if range has no end (i.e `42...`)
    pub right: Option<Box<Node>>,

    /// Location of the `...` operator
    ///
    /// ```text
    /// 1...3
    ///  ~~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// 1...3
    /// ~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Erange {
    // getters

    /// Returns `left` field
    pub fn get_left(&self) -> &Option<Box<Node>> {
        &self.left
    }

    /// Returns `right` field
    pub fn get_right(&self) -> &Option<Box<Node>> {
        &self.right
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `left` field
    pub fn set_left(&mut self, left: Option<Box<Node>>) {
        self.left = left;
    }

    /// Sets `right` field
    pub fn set_right(&mut self, right: Option<Box<Node>>) {
        self.right = right;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalErange {
        let Self { left, right, operator_l, expression_l,  } = self;
        super::InternalErange { left, right, operator_l, expression_l,  }
    }
}

impl InnerNode for Erange {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_left());
        result.push_maybe_node_or_nil(self.get_right());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "erange"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_left().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_right().as_ref() { node.inner_ref().print_with_locs() }
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
