// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a block of code with `ensure` (i.e. `begin; ensure; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Ensure {
    /// Block of code that is wrapped into `ensure`
    /// **Note**: that's the body of the `ensure` block
    ///
    /// `Int("1")` for `begin; 1; ensure; 2; end`
    pub body: Option<Box<Node>>,

    /// Body of the `ensure` block
    ///
    /// `Int("2")` for `begin; 1; ensure; 2; end`
    pub ensure: Option<Box<Node>>,

    /// Location of the `ensure` keyword
    ///
    /// ```text
    /// begin; ensure; end
    ///        ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// begin; 1; rescue; 2; else; 3; ensure; 4; end
    ///        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    ///
    /// **Note**: begin/end belong to `KwBegin` node.
    pub expression_l: Loc,

}

impl Ensure {
    // getters

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `ensure` field
    pub fn get_ensure(&self) -> &Option<Box<Node>> {
        &self.ensure
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `ensure` field
    pub fn set_ensure(&mut self, ensure: Option<Box<Node>>) {
        self.ensure = ensure;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalEnsure {
        let Self { body, ensure, keyword_l, expression_l,  } = self;
        super::InternalEnsure { body, ensure, keyword_l, expression_l,  }
    }
}

impl InnerNode for Ensure {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_body());
        result.push_maybe_node_or_nil(self.get_ensure());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "ensure"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_ensure().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}
