// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a special empty else that is a part of the pattern matching.
///
/// Usually empty else (e.g. part of the `if` statement) doesn't mean anything,
/// however in pattern matching it prevents raising a `NoPatternError`.
///
/// Throwing away this `else` may affect your code.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct EmptyElse {
    /// Location of the `else` keyword
    ///
    /// ```text
    /// case foo; in 1; else; end
    ///                 ~~~~
    /// ```
    pub expression_l: Loc,

}

impl EmptyElse {
    // getters

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalEmptyElse {
        let Self { expression_l,  } = self;
        super::InternalEmptyElse { expression_l,  }
    }
}

impl InnerNode for EmptyElse {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "empty_else"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}
