// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a symbol with interpolation (i.e. `:"#{foo}"`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Dsym {
    /// A list of symbol parts (static literals and interpolated expressions)
    pub parts: Vec<Node>,

    /// Location of the symbol begin
    ///
    /// ```text
    /// :"#{foo}"
    /// ~~
    /// ```
    ///
    /// `None` if `Dsym` is a part of the interpolated symbol array:
    ///
    /// ```text
    /// %I[#{bar}]
    /// ```
    pub begin_l: Option<Loc>,

    /// Location of the symbol begin
    ///
    /// ```text
    /// :"#{foo}"
    ///         ~
    /// ```
    ///
    /// `None` if `Dsym` is a part of the interpolated symbol array:
    ///
    /// ```text
    /// %I[#{bar}]
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// :"#{foo}"
    /// ~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Dsym {
    // getters

    /// Returns `parts` field
    pub fn get_parts(&self) -> &Vec<Node> {
        &self.parts
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `parts` field
    pub fn set_parts(&mut self, parts: Vec<Node>) {
        self.parts = parts;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Option<Loc>) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalDsym {
        let Self { parts, begin_l, end_l, expression_l,  } = self;
        super::InternalDsym { parts, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for Dsym {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_parts());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "dsym"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_parts().iter() { node.inner_ref().print_with_locs(); }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}
