// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents method definition using `def` keyword (not on a singleton, see `Defs` node).
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Def {
    /// Name of the method, `String("foo")` for `def foo; end`
    pub name: String,

    /// Arguments of a method, `None` if there's no arguments.
    ///
    /// All information about parentheses around arguments is stored in this node.
    pub args: Option<Box<Node>>,

    /// Body of a method, `None` if there's no body.
    pub body: Option<Box<Node>>,

    /// Location of the `def` keyword.
    ///
    /// ```text
    /// def foo; end
    /// ~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the method name.
    ///
    /// ```text
    /// def foo; end
    ///     ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `end` keyword.
    ///
    /// ```text
    /// def foo; end
    ///          ~~~
    /// ```
    ///
    /// `None` for endless method definition
    pub end_l: Option<Loc>,

    /// Location of the `=` operator for endless method definition
    ///
    /// ```text
    /// def m() = 1
    ///         ~
    /// ```
    ///
    /// `None` for regular method definition
    pub assignment_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(a); foo; end
    /// ~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Def {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `args` field
    pub fn get_args(&self) -> &Option<Box<Node>> {
        &self.args
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    /// Returns `assignment_l` field
    pub fn get_assignment_l(&self) -> &Option<Loc> {
        &self.assignment_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: Option<Box<Node>>) {
        self.args = args;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Option<Loc>) {
        self.end_l = end_l;
    }

    /// Sets `assignment_l` field
    pub fn set_assignment_l(&mut self, assignment_l: Option<Loc>) {
        self.assignment_l = assignment_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalDef {
        let Self { name, args, body, keyword_l, name_l, end_l, assignment_l, expression_l,  } = self;
        super::InternalDef { name, args, body, keyword_l, name_l, end_l, assignment_l, expression_l,  }
    }
}

impl InnerNode for Def {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        result.push_maybe_node_or_nil(self.get_args());
        result.push_maybe_node_or_nil(self.get_body());





        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "def"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        if let Some(node) = self.get_args().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_name_l().print("name");
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        if let Some(loc) = self.get_assignment_l().as_ref() { loc.print("assignment") }
        self.get_expression_l().print("expression");
    }
}
