// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalConstPattern;
use crate::blobs::{HasBlob, Blob};

/// Const pattern used in pattern matching (e.g. `in A(1, 2)`)
#[repr(C)]
pub struct ConstPattern {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for ConstPattern {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("ConstPattern")
            .field("const_", &self.get_const())
            .field("pattern", &self.get_pattern())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for ConstPattern {
    fn eq(&self, other: &Self) -> bool {
        if self.get_const() != other.get_const() {
            return false
        }
        if self.get_pattern() != other.get_pattern() {
            return false
        }
        if self.get_begin_l() != other.get_begin_l() {
            return false
        }
        if self.get_end_l() != other.get_end_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl ConstPattern {
    // getters
    /// Returns `const_` field
    pub fn get_const(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const_pattern__get_const(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `pattern` field
    pub fn get_pattern(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const_pattern__get_pattern(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const_pattern__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const_pattern__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const_pattern__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `const_` field
    pub fn set_const(&mut self, const_: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__const_pattern__set_const(&mut self.blob, const_.into_blob()) }
    }
    /// Sets `pattern` field
    pub fn set_pattern(&mut self, pattern: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__const_pattern__set_pattern(&mut self.blob, pattern.into_blob()) }
    }
    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__const_pattern__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }
    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__const_pattern__set_end_l(&mut self.blob, end_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__const_pattern__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalConstPattern {
        unsafe { lib_ruby_parser__external__nodes__const_pattern__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__const_pattern__get_const(blob: *const Blob<ConstPattern>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__const_pattern__set_const(blob: *mut Blob<ConstPattern>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__const_pattern__get_pattern(blob: *const Blob<ConstPattern>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__const_pattern__set_pattern(blob: *mut Blob<ConstPattern>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__const_pattern__get_begin_l(blob: *const Blob<ConstPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__const_pattern__set_begin_l(blob: *mut Blob<ConstPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__const_pattern__get_end_l(blob: *const Blob<ConstPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__const_pattern__set_end_l(blob: *mut Blob<ConstPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__const_pattern__get_expression_l(blob: *const Blob<ConstPattern>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__const_pattern__set_expression_l(blob: *mut Blob<ConstPattern>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__const_pattern__into_internal(blob: Blob<ConstPattern>) -> InternalConstPattern;
    fn lib_ruby_parser__external__nodes__const_pattern__drop(blob: *mut Blob<ConstPattern>);
}

impl InnerNode for ConstPattern {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_const());
        result.push_node(self.get_pattern());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "const_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_const().inner_ref().print_with_locs();
        self.get_pattern().inner_ref().print_with_locs();
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for ConstPattern {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__const_pattern__drop(&mut self.blob) }
    }
}
