// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents constant access (i.e. `Foo::Bar`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Const {
    /// Scope where the constant is taken from:
    /// 1. `Some(Const("A"))` for `A::B`
    /// 2. `None` if it's taken from the current scope (i.e. `A`)
    /// 3. `Some(Cbase)` if it's taken from the global scope (i.e. `::A`)
    pub scope: Option<Box<Node>>,

    /// Name of the constant, `String("Foo")` for `Foo`
    pub name: String,

    /// Location of the `::` operator. `None` if constant is taken from the current scope.
    ///
    /// ```text
    /// A::B
    ///  ~~
    /// ```
    pub double_colon_l: Option<Loc>,

    /// Location of the constant name
    ///
    /// ```text
    /// Foo::Bar
    ///      ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// Foo::Bar
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Const {
    // getters

    /// Returns `scope` field
    pub fn get_scope(&self) -> &Option<Box<Node>> {
        &self.scope
    }

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `double_colon_l` field
    pub fn get_double_colon_l(&self) -> &Option<Loc> {
        &self.double_colon_l
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `scope` field
    pub fn set_scope(&mut self, scope: Option<Box<Node>>) {
        self.scope = scope;
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `double_colon_l` field
    pub fn set_double_colon_l(&mut self, double_colon_l: Option<Loc>) {
        self.double_colon_l = double_colon_l;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalConst {
        let Self { scope, name, double_colon_l, name_l, expression_l,  } = self;
        super::InternalConst { scope, name, double_colon_l, name_l, expression_l,  }
    }
}

impl InnerNode for Const {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_scope());
        result.push_str(self.get_name());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "const"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_scope().as_ref() { node.inner_ref().print_with_locs() }

        if let Some(loc) = self.get_double_colon_l().as_ref() { loc.print("double_colon") }
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}
