// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalCasgn;
use crate::blobs::{HasBlob, Blob};

/// Represents a constant assignment (i.e. `A = 1`)
#[repr(C)]
pub struct Casgn {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Casgn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Casgn")
            .field("scope", &self.get_scope())
            .field("name", &self.get_name())
            .field("value", &self.get_value())
            .field("double_colon_l", &self.get_double_colon_l())
            .field("name_l", &self.get_name_l())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Casgn {
    fn eq(&self, other: &Self) -> bool {
        if self.get_scope() != other.get_scope() {
            return false
        }
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_value() != other.get_value() {
            return false
        }
        if self.get_double_colon_l() != other.get_double_colon_l() {
            return false
        }
        if self.get_name_l() != other.get_name_l() {
            return false
        }
        if self.get_operator_l() != other.get_operator_l() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Casgn {
    // getters
    /// Returns `scope` field
    pub fn get_scope(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__casgn__get_scope(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__casgn__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `value` field
    pub fn get_value(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__casgn__get_value(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `double_colon_l` field
    pub fn get_double_colon_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__casgn__get_double_colon_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__casgn__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__casgn__get_operator_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__casgn__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `scope` field
    pub fn set_scope(&mut self, scope: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__casgn__set_scope(&mut self.blob, scope.into_blob()) }
    }
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__casgn__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `value` field
    pub fn set_value(&mut self, value: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__casgn__set_value(&mut self.blob, value.into_blob()) }
    }
    /// Sets `double_colon_l` field
    pub fn set_double_colon_l(&mut self, double_colon_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__casgn__set_double_colon_l(&mut self.blob, double_colon_l.into_blob()) }
    }
    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__casgn__set_name_l(&mut self.blob, name_l.into_blob()) }
    }
    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__casgn__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__casgn__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalCasgn {
        unsafe { lib_ruby_parser__external__nodes__casgn__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__casgn__get_scope(blob: *const Blob<Casgn>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__casgn__set_scope(blob: *mut Blob<Casgn>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__casgn__get_name(blob: *const Blob<Casgn>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__casgn__set_name(blob: *mut Blob<Casgn>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__casgn__get_value(blob: *const Blob<Casgn>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__casgn__set_value(blob: *mut Blob<Casgn>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__casgn__get_double_colon_l(blob: *const Blob<Casgn>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__casgn__set_double_colon_l(blob: *mut Blob<Casgn>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__casgn__get_name_l(blob: *const Blob<Casgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__casgn__set_name_l(blob: *mut Blob<Casgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__casgn__get_operator_l(blob: *const Blob<Casgn>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__casgn__set_operator_l(blob: *mut Blob<Casgn>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__casgn__get_expression_l(blob: *const Blob<Casgn>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__casgn__set_expression_l(blob: *mut Blob<Casgn>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__casgn__into_internal(blob: Blob<Casgn>) -> InternalCasgn;
    fn lib_ruby_parser__external__nodes__casgn__drop(blob: *mut Blob<Casgn>);
}

impl InnerNode for Casgn {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_scope());
        result.push_str(self.get_name());
        result.push_maybe_node(self.get_value());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "casgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_scope().as_ref() { node.inner_ref().print_with_locs() }

        if let Some(node) = self.get_value().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(loc) = self.get_double_colon_l().as_ref() { loc.print("double_colon") }
        self.get_name_l().print("name");
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Casgn {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__casgn__drop(&mut self.blob) }
    }
}
