// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `case` statement used for pattern matching (for regular `case` see `Case` node)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct CaseMatch {
    /// Expression given to `case`, `Int("1")` for `case 1; in 1; end`
    /// `None` for code like
    ///
    /// ```text
    /// case
    /// in pattern
    /// end
    /// ```
    pub expr: Box<Node>,

    /// A list of `InPattern` nodes (each has `pattern`, `guard` and `body`)
    pub in_bodies: Vec<Node>,

    /// Body of the `else` branch, `None` if there's no `else` branch
    pub else_body: Option<Box<Node>>,

    /// Location of the `case` keyword
    ///
    /// ```text
    /// case 1; in 2; end
    /// ~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `else` keyword
    ///
    /// ```text
    /// case 1; in 2; else; end
    ///               ~~~~
    /// ```
    ///
    /// `None` if there's no `else` branch
    pub else_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// case 1; in 2; end
    ///               ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case 1; in 2; end
    /// ~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl CaseMatch {
    // getters

    /// Returns `expr` field
    pub fn get_expr(&self) -> &Box<Node> {
        &self.expr
    }

    /// Returns `in_bodies` field
    pub fn get_in_bodies(&self) -> &Vec<Node> {
        &self.in_bodies
    }

    /// Returns `else_body` field
    pub fn get_else_body(&self) -> &Option<Box<Node>> {
        &self.else_body
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `else_l` field
    pub fn get_else_l(&self) -> &Option<Loc> {
        &self.else_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `expr` field
    pub fn set_expr(&mut self, expr: Box<Node>) {
        self.expr = expr;
    }

    /// Sets `in_bodies` field
    pub fn set_in_bodies(&mut self, in_bodies: Vec<Node>) {
        self.in_bodies = in_bodies;
    }

    /// Sets `else_body` field
    pub fn set_else_body(&mut self, else_body: Option<Box<Node>>) {
        self.else_body = else_body;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `else_l` field
    pub fn set_else_l(&mut self, else_l: Option<Loc>) {
        self.else_l = else_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalCaseMatch {
        let Self { expr, in_bodies, else_body, keyword_l, else_l, end_l, expression_l,  } = self;
        super::InternalCaseMatch { expr, in_bodies, else_body, keyword_l, else_l, end_l, expression_l,  }
    }
}

impl InnerNode for CaseMatch {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_expr());
        result.push_nodes(self.get_in_bodies());
        result.push_maybe_node_or_nil(self.get_else_body());




        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "case_match"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expr().inner_ref().print_with_locs();
        for node in self.get_in_bodies().iter() { node.inner_ref().print_with_locs(); }
        if let Some(node) = self.get_else_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_else_l().as_ref() { loc.print("else") }
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
