// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a `&blk` argument in the method definition (but not in the method call, see `BlockPass`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Blockarg {
    /// Name of the argument, `String("foo")` for `def m(&foo)`
    pub name: String,

    /// Location of the `&` operator
    ///
    /// ```text
    /// def m(&foo); end
    ///       ~
    /// ```
    pub operator_l: Loc,

    /// Location of the name
    ///
    /// ```text
    /// def m(&foo); end
    ///        ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// def m(&foo); end
    ///       ~~~~
    /// ```
    pub expression_l: Loc,

}

impl Blockarg {
    // getters

    /// Returns `name` field
    pub fn get_name(&self) -> &String {
        &self.name
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `name` field
    pub fn set_name(&mut self, name: String) {
        self.name = name;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        self.name_l = name_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalBlockarg {
        let Self { name, operator_l, name_l, expression_l,  } = self;
        super::InternalBlockarg { name, operator_l, name_l, expression_l,  }
    }
}

impl InnerNode for Blockarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "blockarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_operator_l().print("operator");
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}
