// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `&blk` argument of the method call (but not of the method definition, see `BlockArg`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct BlockPass {
    /// Value that is converted to a block
    ///
    /// `Int("1")` in `foo(&1)` (yes, it's possible)
    pub value: Box<Node>,

    /// Location of the `&` operator
    ///
    /// ```text
    /// foo(&blk)
    ///     ~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo(&bar)
    ///     ~~~~
    /// ```
    pub expression_l: Loc,

}

impl BlockPass {
    // getters

    /// Returns `value` field
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `value` field
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        self.operator_l = operator_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalBlockPass {
        let Self { value, operator_l, expression_l,  } = self;
        super::InternalBlockPass { value, operator_l, expression_l,  }
    }
}

impl InnerNode for BlockPass {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_value());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "block_pass"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_value().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}
