// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a Ruby block that is passed to a method (`proc { |foo| bar }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Block {
    /// Method call that takes a block
    ///
    /// `Send("foo")` in `foo {}`
    pub call: Box<Node>,

    /// A list of argument that block takes
    ///
    /// `vec![ Arg("a"), Optarg("b", Int("1")) ]` for `proc { |a, b = 1| }`
    ///
    /// `None` if the block takes no arguments
    pub args: Option<Box<Node>>,

    /// Block body, `None` if block has no body.
    pub body: Option<Box<Node>>,

    /// Location of the open brace
    ///
    /// ```text
    /// proc { }
    ///      ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing brace
    ///
    /// ```text
    /// proc { }
    ///        ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// proc { }
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Block {
    // getters

    /// Returns `call` field
    pub fn get_call(&self) -> &Box<Node> {
        &self.call
    }

    /// Returns `args` field
    pub fn get_args(&self) -> &Option<Box<Node>> {
        &self.args
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `call` field
    pub fn set_call(&mut self, call: Box<Node>) {
        self.call = call;
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: Option<Box<Node>>) {
        self.args = args;
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Option<Box<Node>>) {
        self.body = body;
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        self.begin_l = begin_l;
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        self.end_l = end_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalBlock {
        let Self { call, args, body, begin_l, end_l, expression_l,  } = self;
        super::InternalBlock { call, args, body, begin_l, end_l, expression_l,  }
    }
}

impl InnerNode for Block {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_call());
        result.push_maybe_node_or_nil(self.get_args());
        result.push_maybe_node_or_nil(self.get_body());



        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "block"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_call().inner_ref().print_with_locs();
        if let Some(node) = self.get_args().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}
