// This file is auto-generated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalArg;
use crate::blobs::{HasBlob, Blob};

/// Represents a positional required block/method argument.
///
/// `a` in `def m(a); end` or `proc { |a| }`
#[repr(C)]
pub struct Arg {
    pub(crate) blob: Blob<Self>
}

impl std::fmt::Debug for Arg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Arg")
            .field("name", &self.get_name())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Arg {
    fn eq(&self, other: &Self) -> bool {
        if self.get_name() != other.get_name() {
            return false
        }
        if self.get_expression_l() != other.get_expression_l() {
            return false
        }
        true
    }
}

impl Arg {
    // getters
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__arg__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__arg__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    // setters
    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__arg__set_name(&mut self.blob, name.into_blob()) }
    }
    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__arg__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalArg {
        unsafe { lib_ruby_parser__external__nodes__arg__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__arg__get_name(blob: *const Blob<Arg>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__arg__set_name(blob: *mut Blob<Arg>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__arg__get_expression_l(blob: *const Blob<Arg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__arg__set_expression_l(blob: *mut Blob<Arg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__arg__into_internal(blob: Blob<Arg>) -> InternalArg;
    fn lib_ruby_parser__external__nodes__arg__drop(blob: *mut Blob<Arg>);
}

impl InnerNode for Arg {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());

        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "arg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));

        self.get_expression_l().print("expression");
    }
}

impl Drop for Arg {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__arg__drop(&mut self.blob) }
    }
}
