// This file is auto-generated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `alias to from` statement.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Alias {
    /// Target of the `alias`.
    ///
    /// `Sym("foo")` node for `alias :foo :bar`
    pub to: Box<Node>,

    /// Source of the `alias`.
    ///
    /// `Sym("bar")` node for `alias :foo :bar`
    pub from: Box<Node>,

    /// Location of the `alias` keyword
    ///
    /// ```text
    /// alias foo bar
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// alias foo bar
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,

}

impl Alias {
    // getters

    /// Returns `to` field
    pub fn get_to(&self) -> &Box<Node> {
        &self.to
    }

    /// Returns `from` field
    pub fn get_from(&self) -> &Box<Node> {
        &self.from
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }


    // setters

    /// Sets `to` field
    pub fn set_to(&mut self, to: Box<Node>) {
        self.to = to;
    }

    /// Sets `from` field
    pub fn set_from(&mut self, from: Box<Node>) {
        self.from = from;
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        self.keyword_l = keyword_l;
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        self.expression_l = expression_l;
    }


    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalAlias {
        let Self { to, from, keyword_l, expression_l,  } = self;
        super::InternalAlias { to, from, keyword_l, expression_l,  }
    }
}

impl InnerNode for Alias {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_to());
        result.push_node(self.get_from());


        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "alias"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_to().inner_ref().print_with_locs();
        self.get_from().inner_ref().print_with_locs();
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}
