use crate::codegen::rust::nodes::helpers::filename;
use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

{{ each node }}<dnl>
mod {{ helper mod-name }};
{{ end }}

{{ each node }}<dnl>
pub use {{ helper mod-name }}::{{ helper node-rust-camelcase-name }};
{{ end }}

pub(crate) mod internal {
{{ each node }}<dnl>
    #[allow(unused_imports)]
    pub(crate) use super::{{ helper mod-name }}::Internal{{ helper node-rust-camelcase-name }} as {{ helper node-rust-camelcase-name }};
{{ end }}
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = crate::codegen::fns::default_fns!();

    fns.register_helper("mod-name", filename);

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/nodes/types/mod.rs", contents).unwrap();
}
