use crate::codegen::rust::nodes::helpers::filename;
use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

{{ helper imports }}

#[repr(C)]
pub(crate) struct Internal{{ helper node-rust-camelcase-name }} {
{{ each node-field }}<dnl>
    #[allow(dead_code)]
    pub(crate) {{ helper node-field-rust-field-name }}: {{ helper node-field-rust-field-type }},
{{ end }}<dnl>
}
";

pub(crate) fn codegen(node: &lib_ruby_parser_nodes::Node) {
    let template = NodeTemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = crate::codegen::fns::default_fns!();

    fns.register_helper("imports", local_helpers::imports);

    let contents = template.render(node, &fns);

    let dir = filename(node);
    let path = format!("src/nodes/types/{}/internal.rs", dir);
    std::fs::write(&path, contents).unwrap();
}

mod local_helpers {
    use lib_ruby_parser_nodes::Node;

    pub(crate) fn imports(node: &Node) -> String {
        use lib_ruby_parser_nodes::NodeFieldType;

        let mut imports = vec![];
        imports.push("use crate::Loc;");

        let has_field = |field_type: NodeFieldType| node.fields.any_field_has_type(field_type);

        if has_field(NodeFieldType::Node)
            || has_field(NodeFieldType::Nodes)
            || has_field(NodeFieldType::MaybeNode {
                regexp_options: true,
            })
            || has_field(NodeFieldType::MaybeNode {
                regexp_options: false,
            })
        {
            imports.push("use crate::Node;");
        }

        if has_field(NodeFieldType::StringValue) {
            imports.push("use crate::Bytes;");
        }

        if has_field(NodeFieldType::MaybeNode {
            regexp_options: true,
        }) || has_field(NodeFieldType::MaybeNode {
            regexp_options: false,
        }) || has_field(NodeFieldType::MaybeLoc)
            || has_field(NodeFieldType::MaybeStr { chars: true })
            || has_field(NodeFieldType::MaybeStr { chars: false })
        {
            imports.push("crate::use_native_or_external!(Maybe);");
        }

        if has_field(NodeFieldType::Node)
            || has_field(NodeFieldType::MaybeNode {
                regexp_options: true,
            })
            || has_field(NodeFieldType::MaybeNode {
                regexp_options: false,
            })
        {
            imports.push("crate::use_native_or_external!(Ptr);");
        }

        if has_field(NodeFieldType::Nodes) {
            imports.push("crate::use_native_or_external!(List);");
        }

        if has_field(NodeFieldType::Str { raw: true })
            || has_field(NodeFieldType::Str { raw: false })
            || has_field(NodeFieldType::MaybeStr { chars: true })
            || has_field(NodeFieldType::MaybeStr { chars: false })
        {
            imports.push("crate::use_native_or_external!(StringPtr);");
        }

        imports.join("\n")
    }
}
