use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

use crate::nodes::InnerNode;
use crate::nodes::*;
use crate::Loc;
use crate::Bytes;
crate::use_native_or_external!(Ptr);
crate::use_native_or_external!(List);
crate::use_native_or_external!(Maybe);
crate::use_native_or_external!(StringPtr);

/// Generic combination of all known nodes.
#[allow(missing_docs)]
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub enum Node {
{{ each node }}<dnl>
    {{ helper node-rust-camelcase-name }}({{ helper node-rust-camelcase-name }}),
{{ end }}<dnl>
}

impl Node {
    pub(crate) fn inner_ref(&self) -> &dyn InnerNode {
        match &self {
{{ each node }}<dnl>
            Node::{{ helper node-rust-camelcase-name }}(inner) => inner,
{{ end }}<dnl>
        }
    }

    // new_<node> FNs
{{ each node }}<dnl>
    /// Constructs `Node::{{ helper node-rust-camelcase-name }}` variant
    pub(crate) fn new_{{ helper node-lower-name }}({{ each node-field }}{{ helper node-field-rust-field-name }}: {{ helper node-field-rust-field-type }}, {{ end }}) -> Self {
        Self::{{ helper node-rust-camelcase-name }}({{ helper node-rust-camelcase-name }} { {{ each node-field }}{{ helper node-field-rust-field-name }}, {{ end }} })
    }
{{ end }}<dnl>

    // is_<node> FNs
{{ each node }}<dnl>
    /// Returns true if `self` is `Node::{{ helper node-rust-camelcase-name }}`
    pub fn is_{{ helper node-lower-name }}(&self) -> bool {
        matches!(self, Self::{{ helper node-rust-camelcase-name }}(_))
    }
{{ end }}<dnl>

    // as_<node> FNs
{{ each node }}<dnl>
    /// Casts `&Node` to `Option<&nodes::{{ helper node-rust-camelcase-name }}>`
    pub fn as_{{ helper node-lower-name }}(&self) -> Option<&{{ helper node-rust-camelcase-name }}> {
        if let Self::{{ helper node-rust-camelcase-name }}(inner) = self {
            Some(inner)
        } else {
            None
        }
    }
{{ end }}<dnl>

    // as_<node>_mut FNs
{{ each node }}<dnl>
    /// Casts `&Node` to `Option<&mut nodes::{{ helper node-rust-camelcase-name }}>`
    pub fn as_{{ helper node-lower-name }}_mut(&mut self) -> Option<&mut {{ helper node-rust-camelcase-name }}> {
        if let Self::{{ helper node-rust-camelcase-name }}(inner) = self {
            Some(inner)
        } else {
            None
        }
    }
{{ end }}<dnl>

    // into_<node> FNs
{{ each node }}<dnl>
    /// Casts `self` to `nodes::{{ helper node-rust-camelcase-name }}`, panics if variant doesn't match
    pub fn into_{{ helper node-lower-name }}(self) -> {{ helper node-rust-camelcase-name }} {
        if let Self::{{ helper node-rust-camelcase-name }}(inner) = self {
            inner
        } else {
            panic!(\"bug: expected type {{ helper node-rust-camelcase-name }}, got {:?}\", self)
        }
    }
{{ end }}<dnl>
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/nodes/node_enum/native.rs", contents).unwrap();
}
