use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

crate::use_native_or_external!(StringPtr);

{{ each message }}<dnl>
{{ helper message-comment }}
#[derive(Debug, PartialEq, Eq, Clone)]
pub struct {{ helper message-camelcase-name }} {
{{ each message-field }}<dnl>
    {{ helper mesage-field-comment }}
    pub {{ helper message-field-name }}: {{ helper message-field-rust-field-type }},
{{ end }}<dnl>
}

impl {{ helper message-camelcase-name }} {
{{ each message-field }}<dnl>
    /// Returns `{{ helper message-field-name }}` field
    pub fn get_{{ helper message-field-name }}(&self) -> &{{ helper message-field-rust-field-type }} {
        &self.{{ helper message-field-name }}
    }
{{ end }}<dnl>
}

{{ end }}<dnl>

impl crate::DiagnosticMessage {
{{ each message }}<dnl>
    /// Casts `self` to `Option<&{{ helper message-camelcase-name }}>`, return `None` if variant doesn't match
    pub fn as_{{ helper message-lower-name }}(&self) -> Option<&{{ helper message-camelcase-name }}> {
        match self {
            Self::{{ helper message-camelcase-name }}(variant) => Some(variant),
            _ => None
        }
    }
{{ end }}<dnl>
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/error/message/native/variants.rs", contents).unwrap();
}
