use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is auto-generated by {{ helper generated-by }}

use super::{DiagnosticMessage};

impl std::fmt::Debug for DiagnosticMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
{{ each message }}<dnl>
        if let Some(inner) = self.as_{{ helper message-lower-name }}() {
            return write!(f, \"{{ helper message-camelcase-name }}({:?})\", inner)
        }
{{ end }}<dnl>
        panic!(\"unrecognized diagnostic message type\")
    }
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("src/error/message/external/impl_debug.rs", contents).unwrap();
}
