use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "#ifndef LIB_RUBY_PARSER_EXTERNAL_C_NODES_HPP
#define LIB_RUBY_PARSER_EXTERNAL_C_NODES_HPP

// This file is autogenerated by {{ helper generated-by }}

#include <variant>

namespace lib_ruby_parser
{
    class Node;
    typedef std::unique_ptr<Node> NodePtr;
    typedef std::unique_ptr<Node> MaybeNodePtr;
    using NodeList = List<Node>;

    // classes
{{ each node }}<dnl>
    class {{ helper node-camelcase-name }}
    {
    public:
{{ each node-field }}<dnl>
        {{ helper node-field-cpp-field-type }} {{ helper node-field-c-name }};
{{ end }}<dnl>

        explicit {{ helper node-camelcase-name }}(<dnl>
{{ each node-field }}<dnl>
{{ helper node-field-cpp-field-type }} {{ helper node-field-c-name }}{{ if node-field-is-last }}{{ else }}, {{ end }}<dnl>
{{ end }});

        {{ helper node-camelcase-name }}(const {{ helper node-camelcase-name }} &) = delete;
        {{ helper node-camelcase-name }} &operator=(const {{ helper node-camelcase-name }} &other) = delete;

        {{ helper node-camelcase-name }}({{ helper node-camelcase-name }} &&) = default;
        {{ helper node-camelcase-name }} &operator=({{ helper node-camelcase-name }} &&other) = default;
    };
{{ end }}<dnl>

    typedef std::variant<
{{ each node }}<dnl>
        {{ helper node-camelcase-name }}{{ if node-is-last }}{{ else }},{{ end }}
{{ end }}<dnl>
    > node_variant_t;

    class Node
    {
    public:
        node_variant_t variant;

        Node(node_variant_t variant);

        Node(const Node &) = delete;
        Node &operator=(const Node &other) = delete;

        Node(Node &&) = default;
        Node &operator=(Node &&other) = default;
    };

    void drop_node(Node *node);
    void drop_maybe_node_ptr(std::unique_ptr<Node> *node);
    void drop_node_ptr(std::unique_ptr<Node> *node);
    void drop_node_list(NodeList *node_list);
}

#endif // LIB_RUBY_PARSER_EXTERNAL_C_NODES_HPP
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/cpp/nodes.hpp", contents).unwrap();
}
