use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is autogenerated by {{ helper generated-by }}

#include \"structs.hpp\"

namespace lib_ruby_parser
{
    // constructors
{{ each node }}<dnl>
    {{ helper node-camelcase-name }}::{{ helper node-camelcase-name }}(<dnl>
{{ each node-field }}<dnl>
{{ helper node-field-cpp-field-type }} {{ helper node-field-c-name }}{{ if node-field-is-last }}{{ else }}, {{ end }}<dnl>
{{ end }}) : {{ each node-field }}<dnl>
{{ helper node-field-c-name }}(std::move({{ helper node-field-c-name }})){{ if node-field-is-last }}{{ else }}, {{ end }}<dnl>
{{ end }} {};
{{ end }}<dnl>

    Node::Node(node_variant_t variant) : variant(std::move(variant)) {}

    void drop_node(Node *node)
    {
        node->~Node();
    }

    void drop_maybe_node_ptr(std::unique_ptr<Node> *node)
    {
        node->~unique_ptr();
    }

    void drop_node_ptr(std::unique_ptr<Node> *node)
    {
        node->~unique_ptr();
    }

    void drop_node_list(NodeList *node_list)
    {
        node_list->~List();
    }
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/cpp/nodes.cpp", contents).unwrap();
}
