use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "#ifndef LIB_RUBY_PARSER_EXTERNAL_CPP_SHARED_MESSAGES_HPP
#define LIB_RUBY_PARSER_EXTERNAL_CPP_SHARED_MESSAGES_HPP

// This file is autogenerated by {{ helper generated-by }}

#include <variant>

namespace lib_ruby_parser
{
{{ each message }}<dnl>
    class {{ helper message-camelcase-name }}
    {
    public:
{{ each message-field }}<dnl>
        {{ helper message-field-cpp-field-type }} {{ helper message-field-c-name }};
{{ end }}<dnl>

        {{ helper message-camelcase-name }}(<dnl>
{{ each message-field }}<dnl>
{{ helper message-field-cpp-field-type }} {{ helper message-field-c-name }}{{ if message-field-is-last }}{{ else }}, {{ end }}<dnl>
{{ end }});

        {{ helper message-camelcase-name }}(const {{ helper message-camelcase-name }} &) = delete;
        {{ helper message-camelcase-name }} &operator=(const {{ helper message-camelcase-name }} &other) = delete;

        {{ helper message-camelcase-name }}({{ helper message-camelcase-name }} &&) = default;
        {{ helper message-camelcase-name }} &operator=({{ helper message-camelcase-name }} &&other) = default;
    };
{{ end }}<dnl>

    typedef std::variant<
{{ each message }}<dnl>
        {{ helper message-camelcase-name }}{{ if message-is-last }}{{ else }},{{ end }}
{{ end }}<dnl>
    > diagnostic_message_variant_t;

    class DiagnosticMessage
    {
    public:
        diagnostic_message_variant_t variant;

        DiagnosticMessage(diagnostic_message_variant_t variant);

        DiagnosticMessage(const DiagnosticMessage &) = delete;
        DiagnosticMessage &operator=(const DiagnosticMessage &other) = delete;

        DiagnosticMessage(DiagnosticMessage &&) = default;
        DiagnosticMessage &operator=(DiagnosticMessage &&other) = default;
    };

{{ each message }}<dnl>
    void drop_message_{{ helper message-lower-name }}({{ helper message-camelcase-name }}* variant);
{{ end }}<dnl>

    void drop_diagnostic_message(DiagnosticMessage *message);

    // Diagnostic
    class Diagnostic
    {
    public:
        ErrorLevel level;
        DiagnosticMessage message;
        Loc loc;

        explicit Diagnostic(ErrorLevel level, DiagnosticMessage message, Loc loc);
    };
    using DiagnosticList = List<Diagnostic>;
    void drop_diagnostic(Diagnostic *);
}

#endif // LIB_RUBY_PARSER_EXTERNAL_CPP_SHARED_MESSAGES_HPP
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/cpp/messages.hpp", contents).unwrap();
}
