use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is autogenerated by {{ helper generated-by }}

#include \"structs.hpp\"

namespace lib_ruby_parser
{
    // constructors
{{ each message }}<dnl>
    {{ helper message-camelcase-name }}::{{ helper message-camelcase-name }}(<dnl>
{{ each message-field }}<dnl>
{{ helper message-field-cpp-field-type }} {{ helper message-field-c-name }}{{ if message-field-is-last }}{{ else }}, {{ end }}<dnl>
{{ end }}<dnl>
)<dnl>
{{ if message-has-no-fields }}{{ else }} : {{ end }}<dnl>
{{ each message-field }}<dnl>
{{ helper message-field-c-name }}(std::move({{ helper message-field-c-name }})){{ if message-field-is-last }}{{ else }}, {{ end }}<dnl>
{{ end }}{}
{{ end }}<dnl>

    // variant drop fns
{{ each message }}<dnl>
    void drop_message_{{ helper message-lower-name }}({{ helper message-camelcase-name }}* variant)
    {
        variant->~{{ helper message-camelcase-name }}();
    }
{{ end }}<dnl>

    DiagnosticMessage::DiagnosticMessage(diagnostic_message_variant_t variant): variant(std::move(variant)) {}
    Diagnostic::Diagnostic(
        ErrorLevel level,
        DiagnosticMessage message,
        Loc loc): level(std::move(level)),
                message(std::move(message)),
                loc(std::move(loc)) {}

    void drop_diagnostic_message(DiagnosticMessage *message)
    {
        message->~DiagnosticMessage();
    }
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/cpp/messages.cpp", contents).unwrap();
}
