use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "#ifndef LIB_RUBY_PARSER_SIZES_GEN_H
#define LIB_RUBY_PARSER_SIZES_GEN_H

// This file is autogenerated by {{ helper generated-by }}

#include <stdio.h>
#include \"structs.h\"

void print_node_sizes()
{
{{ each node }}<dnl>
    printf(\"LIB_RUBY_PARSER_NODE_{{ helper node-upper-name }}_SIZE=%lu\\n\", sizeof(LIB_RUBY_PARSER_{{ helper node-camelcase-name }}));
{{ end }}<dnl>
}

void print_messages_sizes()
{
{{ each message }}<dnl>
    printf(\"LIB_RUBY_PARSER_MESSAGE_{{ helper message-upper-name }}_SIZE=%lu\\n\", sizeof(LIB_RUBY_PARSER_{{ helper message-camelcase-name }}));
{{ end }}<dnl>
}

#endif // LIB_RUBY_PARSER_SIZES_GEN_H
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/c/sizes_gen.h", contents).unwrap();
}
