use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "// This file is autogenerated by {{ helper generated-by }}

#include \"structs.h\"
#include <stdio.h>
#include <stdlib.h>

// drop variant fns
{{ each node }}<dnl>
void LIB_RUBY_PARSER_drop_node_{{ helper node-lower-name }}(LIB_RUBY_PARSER_{{ helper node-camelcase-name }} *variant) {
{{ each node-field }}<dnl>
    {{ helper node-field-drop-fn-name }}(&(variant->{{ helper node-field-c-name }}));
{{ end }}<dnl>
}
{{ end }}<dnl>

void LIB_RUBY_PARSER_drop_node(LIB_RUBY_PARSER_Node *node)
{
    switch (node->tag)
    {
{{ each node }}<dnl>
    case {{ helper node-c-enum-variant-name }}:
        LIB_RUBY_PARSER_drop_node_{{ helper node-lower-name }}(&(node->as.{{ helper node-c-union-member-name }}));
        break;
{{ end }}<dnl>
    }
}

void LIB_RUBY_PARSER_drop_maybe_node_ptr(LIB_RUBY_PARSER_Node **node)
{
    LIB_RUBY_PARSER_Node *ptr = *node;
    if (ptr) {
        LIB_RUBY_PARSER_drop_node(ptr);
        free(ptr);
    }
}

void LIB_RUBY_PARSER_drop_node_ptr(LIB_RUBY_PARSER_Node **node)
{
    LIB_RUBY_PARSER_Node *ptr = *node;
    LIB_RUBY_PARSER_drop_node(ptr);
    free(ptr);
}

void lib_ruby_parser__external__list__of_nodes__drop(LIB_RUBY_PARSER_NodeList *);
void LIB_RUBY_PARSER_drop_node_list(LIB_RUBY_PARSER_NodeList *node_list)
{
    lib_ruby_parser__external__list__of_nodes__drop(node_list);
}
";

pub(crate) fn codegen() {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let fns = crate::codegen::fns::default_fns!();

    let contents = template.render(ALL_DATA, &fns);
    std::fs::write("external/c/nodes.c", contents).unwrap();
}
