use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__error_level", GLOBAL_NS)
}

pub fn error_level(options: &Options) -> String {
    format!(
        "
// ErrorLevel
{error_level_blob} {fn_attributes} {ns}__new_warning();
{error_level_blob} {fn_attributes} {ns}__new_error();
void {fn_attributes} {ns}__drop({error_level_blob} *self_blob);
bool {fn_attributes} {ns}__is_warning(const {error_level_blob} *self_blob);
bool {fn_attributes} {ns}__is_error(const {error_level_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        error_level_blob = options.error_level_blob_name,
    )
}
