use super::{fields, ns};
use crate::Options;
use lib_ruby_parser_nodes::{Node, NodeField};

/// Returns name of the node field setter for the given `node`/`field` pair
pub fn name(node: &Node, field: &NodeField) -> String {
    format!(
        "{ns}__{lower}__set_{field_name}",
        ns = ns(),
        lower = node.lower_name(),
        field_name = field.field_name,
    )
}

/// Returns C signature of the node field setter for the given `node`/`field` pair
pub fn sig(node: &Node, field: &NodeField, options: &Options) -> String {
    format!(
        "void {fn_attributes} {setter_name}({node_variant_blob}* self_blob, {value_blob_type} {field_name}_blob)",
        fn_attributes = options.fn_attributes,
        setter_name = name(node, field),
        node_variant_blob = options.node_variant_blob_name(node),
        value_blob_type = fields::field_type(field, options),
        field_name = fields::field_name(field)
    )
}
