use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__shared_byte_list", GLOBAL_NS)
}

pub fn shared_byte_list(options: &Options) -> String {
    format!(
        "
// SharedByteList
{shared_byte_list_blob} {fn_attributes} {ns}__new(const uint8_t *ptr, uint64_t len);
void {fn_attributes} {ns}__drop({shared_byte_list_blob} *self_blob);
const uint8_t *{fn_attributes} {ns}__get_raw(const {shared_byte_list_blob} *self_blob);
uint64_t {fn_attributes} {ns}__get_len(const {shared_byte_list_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        shared_byte_list_blob = options.shared_byte_list_blob_name
    )
}
