use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__ptr", GLOBAL_NS)
}

pub fn ptr(options: &Options) -> String {
    format!(
        "
// Ptr
{ptr_blob} {fn_attributes} {ns}__new(void *ptr);
void {fn_attributes} {ns}__of_node__drop({ptr_blob} *self_blob);
void {fn_attributes} {ns}__of_token__drop({ptr_blob} *self_blob);
void *{fn_attributes} {ns}__get_raw({ptr_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        ptr_blob = options.ptr_blob_name
    )
}
