use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe_token_rewriter", GLOBAL_NS)
}

pub fn maybe_token_rewriter(options: &Options) -> String {
    format!(
        "
// MaybeTokenRewriter
{maybe_token_rewriter_blob} {fn_attributes} {ns}__new_some({token_rewriter_blob} token_rewriter_blob);
{maybe_token_rewriter_blob} {fn_attributes} {ns}__new_none();
void {fn_attributes} {ns}__drop({maybe_token_rewriter_blob} *self_blob);
bool {fn_attributes} {ns}__is_some(const {maybe_token_rewriter_blob} *self_blob);
bool {fn_attributes} {ns}__is_none(const {maybe_token_rewriter_blob} *self_blob);
const {token_rewriter_blob} *{fn_attributes} {ns}__as_token_rewriter(const {maybe_token_rewriter_blob} *self_blob);
{token_rewriter_blob} {fn_attributes} {ns}__into_token_rewriter({maybe_token_rewriter_blob} self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        token_rewriter_blob = options.token_rewriter_blob_name,
        maybe_token_rewriter_blob = options.maybe_token_rewriter_blob_name
    )
}
