use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe_decoder", GLOBAL_NS)
}

pub fn maybe_decoder(options: &Options) -> String {
    format!(
        "
// MaybeDecoder
{maybe_decoder_blob} {fn_attributes} {ns}__new_some({decoder_blob} decoder_blob);
{maybe_decoder_blob} {fn_attributes} {ns}__new_none();
void {fn_attributes} {ns}__drop({maybe_decoder_blob} *self_blob);
bool {fn_attributes} {ns}__is_some(const {maybe_decoder_blob} *self_blob);
bool {fn_attributes} {ns}__is_none(const {maybe_decoder_blob} *self_blob);
const {decoder_blob} *{fn_attributes} {ns}__as_decoder(const {maybe_decoder_blob} *self_blob);
{decoder_blob} {fn_attributes} {ns}__into_decoder({maybe_decoder_blob} self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        decoder_blob = options.decoder_blob_name,
        maybe_decoder_blob = options.maybe_decoder_blob_name
    )
}
