use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__diagnostic", GLOBAL_NS)
}

pub fn diagnostic(options: &Options) -> String {
    format!(
        "
// Diagnostic
{diagnostic_blob} {fn_attributes} {ns}__new(
    {error_level_blob} level_blob,
    {diagnostic_message_blob} message_blob,
    {loc_blob} loc_blob);
void {fn_attributes} {ns}__drop({diagnostic_blob} *self_blob);
const {error_level_blob} *{fn_attributes} {ns}__get_level(const {diagnostic_blob} *self_blob);
const {diagnostic_message_blob} *{fn_attributes} {ns}__get_message(const {diagnostic_blob} *self_blob);
const {loc_blob} *{fn_attributes} {ns}__get_loc(const {diagnostic_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        diagnostic_blob = options.diagnostic_blob_name,
        error_level_blob = options.error_level_blob_name,
        diagnostic_message_blob = options.diagnostic_message_blob_name,
        loc_blob = options.loc_blob_name,
    )
}
