use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__decoder", GLOBAL_NS)
}

pub fn decoder(options: &Options) -> String {
    format!(
        "
// Decoder
{decoder_result_blob} {fn_attributes} {ns}__call(
    {decoder_blob} *self_blob,
    {string_ptr_blob} encoding_blob,
    {byte_list_blob} input_blob);
void {fn_attributes} {ns}__drop({decoder_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        decoder_blob = options.decoder_blob_name,
        decoder_result_blob = options.decoder_result_blob_name,
        string_ptr_blob = options.string_ptr_blob_name,
        byte_list_blob = options.byte_list_blob_name
    )
}
