use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__comment", GLOBAL_NS)
}

pub fn comment(options: &Options) -> String {
    format!(
        "
// Comment
{comment_blob} {fn_attributes} {ns}__new({loc_blob} location_blob, {comment_type_blob} kind_blob);
void {fn_attributes} {ns}__drop({comment_blob} *self_blob);
const {loc_blob} *{fn_attributes} {ns}__get_location(const {comment_blob} *self_blob);
const {comment_type_blob} *{fn_attributes} {ns}__get_kind(const {comment_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        comment_blob = options.comment_blob_name,
        loc_blob = options.loc_blob_name,
        comment_type_blob = options.comment_type_blob_name,
    )
}
