use crate::{generate, Options};
use std::process::Command;

#[test]
fn test_generate() {
    let options = Options {
        pre_code: String::from("#include \"stubs.h\""),
        fn_attributes: String::from("__attribute__((always_inline))"),
        ..Default::default()
    };
    let contents = generate(&options);

    std::fs::write("codegen/bindings.h", contents).unwrap();

    std::fs::write("codegen/message_stubs.h", message_stubs_h(&options)).unwrap();
    std::fs::write("codegen/node_stubs.h", node_stubs_h(&options)).unwrap();

    let output = Command::new("clang")
        .args(&["-fsyntax-only", "-Wall", "-Wextra", "codegen/bindings.h"])
        .output()
        .expect("failed to execute process");

    println!("{:?}", output);
    assert_eq!(output.status.code(), Some(0));
    assert_eq!(output.stdout, b"");
    assert_eq!(output.stderr, b"");
}

fn message_stubs_h(options: &Options) -> String {
    lib_ruby_parser_nodes::messages()
        .map(&|message| {
            format!(
                "typedef struct {{}} {};",
                options.message_variant_blob_name(message)
            )
        })
        .join("\n")
}

fn node_stubs_h(options: &Options) -> String {
    lib_ruby_parser_nodes::nodes()
        .map(&|node| {
            format!(
                "typedef struct {{}} {};",
                options.node_variant_blob_name(node)
            )
        })
        .join("\n")
}
