#![warn(missing_docs)]
#![warn(trivial_casts, trivial_numeric_casts)]
#![warn(unused_qualifications)]
#![warn(deprecated_in_future)]
#![warn(unused_lifetimes)]
#![doc = include_str!("../README.md")]

/// A mod with utility methods to build **implementation** of your bindings
///
/// Header can be generated via `generate` function
pub mod helpers;

mod options;
pub use options::Options;

/// Global namespace of all funcionns that are used in bindings
pub const NS: &'static str = "lib_ruby_parser__external";

mod api;

/// Generates a header file for your bindings
pub fn generate(options: &Options) -> String {
    format!(
        "#ifndef {ifndef_name}
#define {ifndef_name}

{pre_code}
{contents}
{post_code}

#endif // {ifndef_name}
",
        ifndef_name = options.ifndef_name,
        pre_code = options.pre_code,
        post_code = options.post_code,
        contents = contents(&options)
    )
}

fn contents(options: &Options) -> String {
    vec![
        api::ptr(options),
        api::maybe_ptr(options),
        api::string_ptr(options),
        api::maybe_string_ptr(options),
        api::shared_byte_list(options),
        api::list(options),
        api::source_line(options),
        api::bytes(options),
        api::token(options),
        api::comment_type(options),
        api::comment(options),
        api::loc(options),
        api::maybe_loc(options),
        api::magic_comment_kind(options),
        api::magic_comment(options),
        api::error_level(options),
        api::message(options),
        api::diagnostic(options),
        api::node(options),
        api::input_error(options),
        api::decoder_result(options),
        api::decoder(options),
        api::token_rewriter(options),
        api::maybe_decoder(options),
        api::maybe_token_rewriter(options),
        api::parser_options(options),
        api::decoded_input(options),
        api::parser_result(options),
    ]
    .join("")
}

#[cfg(test)]
mod tests;
