use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe_string_ptr", GLOBAL_NS)
}

pub fn maybe_string_ptr(options: &Options) -> String {
    format!(
        "
// MaybeStringPtr
{maybe_string_ptr_blob} {fn_attributes} {ns}__new_some(const uint8_t *ptr, uint64_t len);
{maybe_string_ptr_blob} {fn_attributes} {ns}__new_none();
void {fn_attributes} {ns}__drop({maybe_string_ptr_blob} *self_blob);
bool {fn_attributes} {ns}__is_some(const {maybe_string_ptr_blob} *self_blob);
bool {fn_attributes} {ns}__is_none(const {maybe_string_ptr_blob} *self_blob);
uint8_t *{fn_attributes} {ns}__get_raw({maybe_string_ptr_blob} *self_blob);
uint8_t *{fn_attributes} {ns}__into_raw({maybe_string_ptr_blob} self_blob);
uint64_t {fn_attributes} {ns}__get_len(const {maybe_string_ptr_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        maybe_string_ptr_blob = options.maybe_string_ptr_blob_name
    )
}
