use crate::{Options, NS as GLOBAL_NS};

pub fn list(options: &Options) -> String {
    vec![
        list_of(
            &options.byte_blob_name,
            &options.byte_list_blob_name,
            "of_bytes",
            &options.fn_attributes,
        ),
        list_of(
            &options.token_blob_name,
            &options.token_list_blob_name,
            "of_tokens",
            &options.fn_attributes,
        ),
        list_of(
            &options.node_blob_name,
            &options.node_list_blob_name,
            "of_nodes",
            &options.fn_attributes,
        ),
        list_of(
            &options.diagnostic_blob_name,
            &options.diagnostic_list_blob_name,
            "of_diagnostics",
            &options.fn_attributes,
        ),
        list_of(
            &options.comment_blob_name,
            &options.comment_list_blob_name,
            "of_comments",
            &options.fn_attributes,
        ),
        list_of(
            &options.magic_comment_blob_name,
            &options.magic_comment_list_blob_name,
            "of_magic_comments",
            &options.fn_attributes,
        ),
        list_of(
            &options.source_line_blob_name,
            &options.source_line_list_blob_name,
            "of_source_lines",
            &options.fn_attributes,
        ),
    ]
    .join("\n")
}

fn ns(subns: &str) -> String {
    format!("{}__list__{}", GLOBAL_NS, subns)
}

fn list_of(item_blob: &str, list_blob: &str, subns: &str, fn_attributes: &str) -> String {
    format!(
        "
// List<{item_blob}>
{list_blob} {fn_attributes} {ns}__new();
void {fn_attributes} {ns}__drop({list_blob} *self_blob);
{list_blob} {fn_attributes} {ns}__with_capacity(uint64_t capacity);
{list_blob} {fn_attributes} {ns}__from_raw({item_blob} *ptr, uint64_t len);
void {fn_attributes} {ns}__push({list_blob} *self_blob, {item_blob} item_blob);
{item_blob} {fn_attributes} {ns}__remove({list_blob} *self_blob, uint64_t index);
void {fn_attributes} {ns}__shrink_to_fit({list_blob} *self_blob);
{item_blob} *{fn_attributes} {ns}__as_ptr({list_blob} *self_blob);
uint64_t {fn_attributes} {ns}__get_len(const {list_blob} *self_blob);
uint64_t {fn_attributes} {ns}__get_capacity(const {list_blob} *self_blob);
",
        ns = ns(subns),
        fn_attributes = fn_attributes,
        list_blob = list_blob,
        item_blob = item_blob
    )
}
