use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__decoder_result", GLOBAL_NS)
}

pub fn decoder_result(options: &Options) -> String {
    format!(
        "
// DecoderResult
{decoder_result_blob} {fn_attributes} {ns}__new_ok({byte_list_blob} byte_list_blob);
{decoder_result_blob} {fn_attributes} {ns}__new_err({input_error_blob} input_error_blob);
void {fn_attributes} {ns}__drop({decoder_result_blob}* self_blob);
bool {fn_attributes} {ns}__is_ok(const {decoder_result_blob} *self_blob);
bool {fn_attributes} {ns}__is_err(const {decoder_result_blob} *self_blob);
{byte_list_blob} {fn_attributes} {ns}__into_ok({decoder_result_blob} self_blob);
{input_error_blob} {fn_attributes} {ns}__into_err({decoder_result_blob} self_blob);
const {byte_list_blob} *{fn_attributes} {ns}__as_ok(const {decoder_result_blob} *self_blob);
const {input_error_blob} *{fn_attributes} {ns}__as_err(const {decoder_result_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        decoder_result_blob = options.decoder_result_blob_name,
        byte_list_blob = options.byte_list_blob_name,
        input_error_blob = options.input_error_blob_name
    )
}
