use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__parser_result", GLOBAL_NS)
}

pub fn parser_result(options: &Options) -> String {
    format!(
        "
// ParserResult
{parser_result_blob} {ns}__new(
    {maybe_ptr_blob} ast_blob,
    {token_list_blob} tokens_blob,
    {diagnostic_list_blob} diagnostics_blob,
    {comment_list_blob} comments_blob,
    {magic_comment_list_blob} magic_comments_blob,
    {decoded_input_blob} input_blob);
void {ns}__drop({parser_result_blob} *self_blob);
const {maybe_ptr_blob} *{ns}__get_ast(const {parser_result_blob} *self_blob);
const {token_list_blob} *{ns}__get_tokens(const {parser_result_blob} *self_blob);
const {diagnostic_list_blob} *{ns}__get_diagnostics(const {parser_result_blob} *self_blob);
const {comment_list_blob} *{ns}__get_comments(const {parser_result_blob} *self_blob);
const {magic_comment_list_blob} *{ns}__get_magic_comments(const {parser_result_blob} *self_blob);
const {decoded_input_blob} *{ns}__get_input(const {parser_result_blob} *self_blob);
",
        ns = ns(),
        parser_result_blob = options.parser_result_blob_name,
        maybe_ptr_blob = options.maybe_ptr_blob_name,
        token_list_blob = options.token_list_blob_name,
        diagnostic_list_blob = options.diagnostic_list_blob_name,
        comment_list_blob = options.comment_list_blob_name,
        magic_comment_list_blob = options.magic_comment_list_blob_name,
        decoded_input_blob = options.decoded_input_blob_name,
    )
}
