use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__parser_options", GLOBAL_NS)
}

pub fn parser_options(options: &Options) -> String {
    format!(
        "
// ParserOptions
{parser_options_blob} {ns}__new(
    {string_ptr_blob} buffer_name_blob,
    uint8_t debug,
    {maybe_decoder_blob} decoder_blob,
    {maybe_token_rewriter_blob} token_rewriter_blob,
    bool record_tokens);
void {ns}__drop({parser_options_blob} *self_blob);

#ifdef __cplusplus
extern \"C\" {{
#endif

typedef struct InternalParserOptions {{
    {string_ptr_blob} buffer_name;
    uint8_t debug;
    {maybe_decoder_blob} decoder;
    {maybe_token_rewriter_blob} token_rewriter;
    bool record_tokens;
}} InternalParserOptions;

#ifdef __cplusplus
}}
#endif

InternalParserOptions {ns}__into_internal({parser_options_blob} self_blob);
const {string_ptr_blob} *{ns}__get_buffer_name(const {parser_options_blob} *self_blob);
uint8_t {ns}__get_debug(const {parser_options_blob} *self_blob);
const {maybe_decoder_blob} *{ns}__get_decoder(const {parser_options_blob} *self_blob);
const {maybe_token_rewriter_blob} *{ns}__get_token_rewriter(const {parser_options_blob} *self_blob);
bool {ns}__get_record_tokens(const {parser_options_blob} *self_blob);
",
        ns = ns(),
        parser_options_blob = options.parser_options_blob_name,
        string_ptr_blob = options.string_ptr_blob_name,
        maybe_decoder_blob = options.maybe_decoder_blob_name,
        maybe_token_rewriter_blob = options.maybe_token_rewriter_blob_name
    )
}
