use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe_loc", GLOBAL_NS)
}

pub fn maybe_loc(options: &Options) -> String {
    format!(
        "
// MaybeLoc
{maybe_loc_blob} {ns}__new_some({loc_blob} loc_blob);
{maybe_loc_blob} {ns}__new_none();
void {ns}__drop({maybe_loc_blob} *self_blob);
bool {ns}__is_some(const {maybe_loc_blob} *self_blob);
bool {ns}__is_none(const {maybe_loc_blob} *self_blob);
const {loc_blob} *{ns}__as_loc(const {maybe_loc_blob} *self_blob);
{loc_blob} {ns}__into_loc({maybe_loc_blob} self_blob);
",
        ns = ns(),
        maybe_loc_blob = options.maybe_loc_blob_name,
        loc_blob = options.loc_blob_name
    )
}
