use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe_decoder", GLOBAL_NS)
}

pub fn maybe_decoder(options: &Options) -> String {
    format!(
        "
// MaybeDecoder
{maybe_decoder_blob} {ns}__new_some({decoder_blob} decoder_blob);
{maybe_decoder_blob} {ns}__new_none();
void {ns}__drop({maybe_decoder_blob} *self_blob);
bool {ns}__is_some(const {maybe_decoder_blob} *self_blob);
bool {ns}__is_none(const {maybe_decoder_blob} *self_blob);
const {decoder_blob} *{ns}__as_decoder(const {maybe_decoder_blob} *self_blob);
{decoder_blob} {ns}__into_decoder({maybe_decoder_blob} self_blob);
",
        ns = ns(),
        decoder_blob = options.decoder_blob_name,
        maybe_decoder_blob = options.maybe_decoder_blob_name
    )
}
