use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__loc", GLOBAL_NS)
}

pub fn loc(options: &Options) -> String {
    format!(
        "
// Loc
{loc_blob} {ns}__new(uint64_t begin, uint64_t end);
void {ns}__drop({loc_blob} *self_blob);
uint64_t {ns}__get_begin(const {loc_blob} *self_blob);
uint64_t {ns}__get_end(const {loc_blob} *self_blob);
",
        ns = ns(),
        loc_blob = options.loc_blob_name
    )
}
