#![warn(missing_docs)]
#![warn(trivial_casts, trivial_numeric_casts)]
#![warn(unused_qualifications)]
#![warn(deprecated_in_future)]
#![warn(unused_lifetimes)]
#![doc = include_str!("../README.md")]

/// A mod with utility methods to build **implementation** of your bindings
///
/// Header can be generated via `generate` function
pub mod helpers;

mod options;
pub use options::Options;

/// Global namespace of all funcionns that are used in bindings
pub const NS: &'static str = "lib_ruby_parser__external";

static mut OPTIONS: Option<Options> = None;

pub(crate) fn options() -> &'static Options {
    unsafe { OPTIONS.as_ref().unwrap() }
}

mod api;

/// Generates a header file for your bindings
pub fn generate(gen_options: &Options) -> String {
    unsafe {
        OPTIONS = Some(gen_options.to_owned());
    }

    format!(
        "#ifndef {ifndef_name}
#define {ifndef_name}

{pre_code}
{contents}
{post_code}

#endif // {ifndef_name}
",
        ifndef_name = options().ifndef_name,
        pre_code = options().pre_code,
        post_code = options().post_code,
        contents = contents()
    )
}

fn contents() -> String {
    vec![
        api::ptr(),
        api::maybe(),
        api::string_ptr(),
        api::shared_byte_list(),
        api::list(),
        api::source_line(),
        api::bytes(),
        api::token(),
        api::comment_type(),
        api::comment(),
        api::loc(),
        api::magic_comment_kind(),
        api::magic_comment(),
        api::error_level(),
        api::message(),
        api::diagnostic(),
        api::node(),
        api::input_error(),
        api::decoder_result(),
        api::decoder(),
        api::token_rewriter(),
        api::parser_options(),
        api::decoded_input(),
        api::parser_result(),
    ]
    .join("")
}

#[cfg(test)]
mod tests;
