use super::ns;
use crate::options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the cast-to-variant function for the given `node`
pub fn name(node: &Node) -> String {
    format!("{ns}__get_{lower}", ns = ns(), lower = node.lower_name())
}

/// Returns name of the cast-to-variant function for the given `node`
pub fn sig(node: &Node) -> String {
    format!(
        "{node_variant_blob} *{fn_attributes} {variant_getter_name}({node_blob} *self_blob)",
        node_variant_blob = options().node_variant_blob_name(node),
        fn_attributes = options().fn_attributes,
        variant_getter_name = name(node),
        node_blob = options().node_blob_name
    )
}
