use crate::options;
use lib_ruby_parser_nodes::{NodeField, NodeFieldType};

/// Returns name of the node field that is compatible with C
pub fn field_name(field: &NodeField) -> String {
    match &field.snakecase_name[..] {
        "default" => "default_",
        "operator" => "operator_",
        "else" => "else_",
        "const" => "const_",
        other => other,
    }
    .to_owned()
}

/// Returns type of the node field according to `options` configured by you
pub fn field_type(field: &NodeField) -> &'static str {
    match field.field_type {
        NodeFieldType::Node => options().ptr_blob_name,
        NodeFieldType::Nodes => options().node_list_blob_name,
        NodeFieldType::MaybeNode { .. } => options().maybe_ptr_blob_name,
        NodeFieldType::Loc => options().loc_blob_name,
        NodeFieldType::MaybeLoc => options().maybe_loc_blob_name,
        NodeFieldType::Str { .. } => options().string_ptr_blob_name,
        NodeFieldType::MaybeStr { .. } => options().maybe_string_ptr_blob_name,
        NodeFieldType::StringValue => options().bytes_blob_name,
        NodeFieldType::U8 => options().byte_blob_name,
    }
}
